<?php
/**
 * Plugin Name: AI Image Maker WTP
 * Description: Text-to-image generator powered by OpenAI Dall-E
 * Plugin URI: https://wpthemeplugin.com/
 * Author: Leo BCBiz (WpThemePlugin.com)
 * Version: 1.0.3
 * Author URI: https://wpthemeplugin.com/
 * Requires at least: 5.6
 * Requires PHP: 7.0
*/

if ( ! function_exists( 'wtp_custom_curl_timeout' ) ) {
    add_action('http_api_curl', 'wtp_custom_curl_timeout', 9999, 1);
    function wtp_custom_curl_timeout( $handle ){
	    curl_setopt( $handle, CURLOPT_CONNECTTIMEOUT, 60 );
	    curl_setopt( $handle, CURLOPT_TIMEOUT, 60 );
    }
}

if ( ! function_exists( 'wtp_custom_http_request_timeout' ) ) {
    add_filter( 'http_request_timeout', 'wtp_custom_http_request_timeout', 9999 );
    function wtp_custom_http_request_timeout( $timeout_value ) {
	    return 60;
    }
}

if ( ! function_exists( 'wtp_custom_http_request_args' ) ) {
    add_filter('http_request_args', 'wtp_custom_http_request_args', 9999, 1);
    function wtp_custom_http_request_args( $r ){
	    $r['timeout'] = 60;
	    return $r;
    }
}
require 'kernl-update-checker/kernl-update-checker.php';
//$MyUpdateChecker = Puc_v4_Factory::buildUpdateChecker(
    //'https://kernl.us/api/v1/updates/639a4eb0ba0dbcdbc2c656ae2023/',
    //__FILE__,
    //'ai-image-maker-wtp'
//);
class AIImageMakerWTP {
	private $ai_image_maker_wtp_options;

	public function __construct() {
		add_action( 'admin_menu', array( $this, 'ai_image_maker_wtp_add_plugin_page' ) );
		add_action( 'admin_init', array( $this, 'ai_image_maker_wtp_page_init' ) );
	}

	public function ai_image_maker_wtp_add_plugin_page() {
		add_options_page(
			'AI Image Maker WP Plugin', // page_title
			'AI Image Maker', // menu_title
			'manage_options', // capability
			'ai-image-maker-wtp', // menu_slug
			array( $this, 'ai_image_maker_wtp_create_admin_page' ) // function
		);
	}

	public function ai_image_maker_wtp_create_admin_page() {
		$this->ai_image_maker_wtp_options = get_option( 'ai_image_maker_wtp_option_name' ); ?>

        <style>
            .aiimgmkr-page {
                margin-top:35px;
                max-width:700px;
            }
            .aiimgmkr-header {
                margin-bottom:25px;
            }
            .aiimgmkr-page h2 {
                font-size:22px;
                font-weight:normal;
                padding-bottom:0;
                margin-bottom:8px;
            }
            .aiimgmkr-page h3 {
                font-size:18px;
                font-weight:normal;
                padding-bottom:10px;
                margin-bottom:5px;
                border-bottom:1px solid #ccc;
            }
            .aiimgmkr-none {
                display: none;
            }
        </style>
        
        <?php
        $aiimgmkr_wtp_options = get_option( 'ai_image_maker_wtp_option_name' );
        $aiimgmkr_wtp_apikey = $aiimgmkr_wtp_options['aiimgmkr_wtp_apikey'];
        
        ?>
        
        <div class="wrap"></div>
        
		<div class="aiimgmkr-page">
		    
		    
		    <div class="aiimgmkr-header">
			    <h2>AI Image Maker WTP</h2>
			    <span style="font-size:13px;">Coded by <a href="https://wpthemeplugin.com" target="_blank">WpThemePlugin</a></span>
			</div>
            
			<form method="post" action="options.php">
				<?php
					settings_fields( 'ai_image_maker_wtp_option_group' );
					do_settings_sections( 'ai-image-maker-wtp-admin' );
					submit_button();
				?>
			</form>
			
			
			<h3>Generate New AI Image</h3>
			
			<div style="margin-top:30px;margin-bottom:30px;">
        
                <label for="aiimgmkr-keyword" style="margin-right:10px;font-size:15px;">Enter Keyword:</label>
                <input class="regular-text" placeholder="Example: elon musk eating burger" type="text" name="aiimgmkr-keyword" id="aiimgmkr-keyword" required>
            
                <?php if ($aiimgmkr_wtp_apikey) { ?>
                
                    <div style="margin-top:20px;margin-bottom:20px;">
                        <button type="button" id="aiimgmkr-createbtn" class="button-primary">Create Image</button>
                    </div>
                    
                <?php } else { ?>
                    
                    <div style="margin-top:20px;margin-bottom:20px;">
                        <button type="button" id="aiimgmkr-createbtn" class="button-primary" disabled>Create Image</button>
                        * Please enter your API Key first before using this feature.
                    </div>
                    
                <?php } ?>
                
                <div id="aiimgmkr-loading"></div>
    
                <div id="aiimgmkr-box" class="aiimgmkr-none">
        
                    <p><strong>AI Image Result:</strong></p>
                    <div id="aiimgmkr-resultbox"></div>
                    
                    <div id="aiimgmkr-dlbox" style="margin-top:20px;margin-bottom:20px;">
                    </div>
                     
                </div>
        
            </div>
            
            
            <script>
            document.getElementById( 'aiimgmkr-createbtn' ).addEventListener( 'click', function ( event ) {
		    
		    event.preventDefault();
		    
		    var aicheck = document.getElementById('aiimgmkr-keyword').value;

            if(aicheck.length<5) {
                window.alert ("Enter your keyword on the text field");
            } else {
			
		    var imgtopicInput = document.getElementById( 'aiimgmkr-keyword' );
		    var imagebox = document.getElementById( 'aiimgmkr-box' );
		    var imgpostbox = document.getElementById('aiimgmkr-resultbox');
		    var imgdlbox = document.getElementById('aiimgmkr-dlbox');
			
		    var loadingpict = document.getElementById( 'aiimgmkr-loading' );
		    loadingpict.innerHTML = '<img src="<?php echo admin_url(); ?>images/spinner.gif" alt="Importing...">';
		    loadingpict.classList = 'downloading';
			
		    var ajaxurl = '<?php echo admin_url( 'admin-ajax.php' ); ?>';
		    var xhttp = new XMLHttpRequest();
			
		    var formData = new FormData();
		    formData.append( 'action', 'aiimgmkr_submitaction' );
		    formData.append( 'imgtopic', imgtopicInput.value );
			
		    xhttp.open( "POST", ajaxurl );
		    xhttp.send( formData );
			
		    xhttp.onreadystatechange = function () {
			if ( this.readyState === 4 && this.status === 200 ) {
				var data = JSON.parse( this.responseText );
				if ( data.success === true ) {
					loadingpict.classList.add( 'updated' );
					loadingpict.innerHTML = data.data;
					imagebox.classList.remove( 'aiimgmkr-none' );
					imagebox.classList.add( 'aiimgmkr-display' );
					imgpostbox.innerHTML = data.imglink;
					imgdlbox.innerHTML = data.imgdl;
				} else {
					loadingpict.classList.add( 'error' );
					loadingpict.innerHTML = data.data;
				}
			}
		    };
            }//END CHECK IF EMPTY
		    } );
            </script>
			
		</div>
	<?php }

	public function ai_image_maker_wtp_page_init() {
		register_setting(
			'ai_image_maker_wtp_option_group', // option_group
			'ai_image_maker_wtp_option_name', // option_name
			array( $this, 'ai_image_maker_wtp_sanitize' ) // sanitize_callback
		);

		add_settings_section(
			'ai_image_maker_wtp_setting_section', // id
			'', // title
			array( $this, 'ai_image_maker_wtp_section_info' ), // callback
			'ai-image-maker-wtp-admin' // page
		);

		add_settings_field(
			'aiimgmkr_wtp_apikey', // id
			'Your OpenAI API Key<br><small><a style="display:block;margin-top:5px;font-weight:normal;" href="https://platform.openai.com/account/api-keys" target="_blank">Get Your API Key here</a></small>', // title
			array( $this, 'aiimgmkr_wtp_apikey_callback' ), // callback
			'ai-image-maker-wtp-admin', // page
			'ai_image_maker_wtp_setting_section' // section
		);
	}

	public function ai_image_maker_wtp_sanitize($input) {
		$sanitary_values = array();
		if ( isset( $input['aiimgmkr_wtp_apikey'] ) ) {
			$sanitary_values['aiimgmkr_wtp_apikey'] = sanitize_text_field( $input['aiimgmkr_wtp_apikey'] );
		}

		return $sanitary_values;
	}

	public function ai_image_maker_wtp_section_info() {
		
	}

	public function aiimgmkr_wtp_apikey_callback() {
		printf(
			'<input class="regular-text" type="text" name="ai_image_maker_wtp_option_name[aiimgmkr_wtp_apikey]" id="aiimgmkr_wtp_apikey" value="%s">',
			isset( $this->ai_image_maker_wtp_options['aiimgmkr_wtp_apikey'] ) ? esc_attr( $this->ai_image_maker_wtp_options['aiimgmkr_wtp_apikey']) : ''
		);
	}

}
if ( is_admin() )
	$ai_image_maker_wtp = new AIImageMakerWTP();

/* 
 * Retrieve this value with:
 * $ai_image_maker_wtp_options = get_option( 'ai_image_maker_wtp_option_name' ); // Array of All Options
 * $aiimgmkr_wtp_apikey = $ai_image_maker_wtp_options['aiimgmkr_wtp_apikey']; // Your OpenAI API Key
 */
