<?php

function aiimgmkr_request_image() {
    
    $aiimgmkr_puc_options = get_option( 'ai_image_maker_wtp_option_name' );
    $aiimgmkr_puc_api = $aiimgmkr_puc_options['aiimgmkr_wtp_apikey'];
    
    if (isset($_POST['imgtopic'])) {
        
        $aiimgmkr_topic = sanitize_text_field($_POST["imgtopic"]);
        $aiimgmkr_topic = trim($aiimgmkr_topic);
        
        $aiimgmkr_apiurl = wp_remote_post(
            'https://api.openai.com/v1/images/generations',
            array(
                'headers' => array(
                    'Content-Type' => 'application/json',
                    'Authorization' => 'Bearer ' . $aiimgmkr_puc_api,
                ),
                'body' =>  json_encode([
                    "prompt" => $aiimgmkr_topic,
                    "n" => 1,
                    "size" => "512x512",
                    "response_format" => "url",
                ]),
                'method'      => 'POST',
                'data_format' => 'body',
                //'blocking'    => true,
                'sslverify' => true,
            )
        );
        
        $aiimgmkr_apicontent = json_decode( $aiimgmkr_apiurl['body'] );
        $aiimgmkr_apiimglink = $aiimgmkr_apicontent->data[0]->url;
        
        update_option( 'aiimgmkr_put_imglink', $aiimgmkr_apiimglink );
        
        $aiimgmkr_setimgcontent = get_option( 'aiimgmkr_put_imglink' );
        
        $aiimgmkr_aiimghtml = '<img src="' .$aiimgmkr_setimgcontent. '" class="aiimgmkr-wtp-pict" />';
        $aiimgmkr_aiimgdownload = '<a href="' .$aiimgmkr_setimgcontent. '" class="button" target="_blank">Download Image</a>
        
        <div style="margin-top:30px;margin-bottom:50px;font-size:15px;">
            Thank you for using AI Image Maker plugin from <a href="https://wpthemeplugin.com" target="_blank">WpThemePlugin.com</a>
        </div>';
        
        
        if ( is_wp_error( $aiimgmkr_apiurl ) ) {
			wp_send_json_error( $aiimgmkr_apiurl->get_error_message() );
		} else {
			wp_send_json( array( 'success' => true, 'data' => __( 'Image Created.', 'aiimgmkr-wtp' ), 'imgdl' => $aiimgmkr_aiimgdownload, 'imglink' => $aiimgmkr_aiimghtml ) );
		}
        
    }//if (isset($_POST)
    wp_die();
}

add_action( 'wp_ajax_aiimgmkr_submitaction', 'aiimgmkr_request_image' );
add_action( 'wp_ajax_nopriv_aiimgmkr_submitaction', '__return_zero' );
